# 🚀 راهنمای جامع و قدم‌به‌قدم نصب ربات و وب‌اپلیکیشن روی هاست سی‌پنل (cPanel)

## 📋 پیش‌نیازها
- هاست سی‌پنل با قابلیت **Python App** (معمولاً در بخش Software گزینه "Setup Python App" وجود دارد).
- دسترسی به **MySQL Database**.
- فایل‌های پروژه (که در اختیار دارید).

---

## 1️⃣ مرحله اول: ساخت دیتابیس (Database)
قبل از هر چیز، باید یک دیتابیس برای ذخیره اطلاعات ربات بسازیم.

1. وارد سی‌پنل شوید.
2. به بخش **DATABASES** بروید و روی **MySQL® Database Wizard** کلیک کنید.
3. **Step 1: Create A Database**
   - یک نام برای دیتابیس انتخاب کنید (مثلاً `vpn_bot`) و دکمه **Next Step** را بزنید.
4. **Step 2: Create Database Users**
   - یک نام کاربری (Username) و یک رمز عبور قوی (Password) انتخاب کنید.
   - **نکته مهم:** رمز عبور را حتماً کپی کنید، چون در مراحل بعد به آن نیاز داریم.
   - دکمه **Create User** را بزنید.
5. **Step 3: Add User to the Database**
   - تیک گزینه **ALL PRIVILEGES** را بزنید تا تمام دسترسی‌ها داده شود.
   - دکمه **Make Changes** را بزنید.
   - **تبریک!** دیتابیس شما ساخته شد. نام دیتابیس و نام کاربری (که معمولاً با پیشوند نام هاست شما شروع می‌شوند، مثلا `user_vpn`) را یادداشت کنید.

---

## 2️⃣ مرحله دوم: آپلود فایل‌ها
1. در سی‌پنل به بخش **FILES** و سپس **File Manager** بروید.
2. وارد پوشه اصلی هاست خود شوید (معمولاً `public_html` نیست، بلکه یک پوشه قبل از آن یا پوشه `home` است. اما برای پایتون اپ، بهتر است فایل‌ها را در روت اصلی `home/user` یا یک پوشه مشخص آپلود کنید. پیشنهاد ما: یک پوشه جدید به نام `mybot` بسازید).
3. تمام فایل‌های پروژه را در این پوشه آپلود کنید.

---

## 3️⃣ مرحله سوم: ساخت اپلیکیشن پایتون (Python App)
1. در صفحه اصلی سی‌پنل، به بخش **SOFTWARE** بروید و روی **Setup Python App** کلیک کنید.
2. روی دکمه **CREATE APPLICATION** کلیک کنید.
3. تنظیمات را به صورت زیر انجام دهید:
   - **Python version:** نسخه **3.8** یا بالاتر (پیشنهاد ما: جدیدترین نسخه موجود).
   - **Application root:** آدرس پوشه‌ای که فایل‌ها را در آن آپلود کردید (مثلاً `mybot`).
   - **Application URL:** دامنه‌ای که می‌خواهید وب‌اپلیکیشن روی آن باز شود (مثلاً `mydomain.com` یا `mydomain.com/panel`).
   - **Application startup file:** این قسمت را **خالی بگذارید** (اینستالر ما این را می‌سازد) یا بنویسید `passenger_wsgi.py`.
   - **Application entry point:** این قسمت را هم می‌توانید خالی بگذارید یا بنویسید `application`.
4. دکمه **CREATE** را بزنید.
5. پس از ساخت، در بالای صفحه یک دستور به شما می‌دهد که شبیه به این است:
   `source /home/username/virtualenv/mybot/3.9/bin/activate && cd /home/username/mybot`
   روی این دستور کلیک کنید تا کپی شود.

---

## 4️⃣ مرحله چهارم: اجرای اینستالر هوشمند (جادوی اصلی! ✨)
1. در صفحه اصلی سی‌پنل، به بخش **ADVANCED** بروید و روی **Terminal** کلیک کنید. (اگر ترمینال ندارید، باید از طریق SSH و نرم‌افزار Putty وصل شوید).
2. دستوری که در مرحله قبل کپی کردید را در ترمینال **Paste** کنید و اینتر بزنید. (با این کار وارد محیط مجازی پایتون می‌شوید).
3. حالا دستور زیر را برای اجرای اینستالر تایپ کنید و اینتر بزنید:
   ```bash
   python cpanel_installer.py
   ```
4. **مراحل نصب شروع می‌شود!** اینستالر از شما سوالاتی می‌پرسد:
   - **Bot Token:** توکن ربات تلگرام خود را وارد کنید.
   - **Admin ID:** آیدی عددی تلگرام خود را وارد کنید.
   - **Database Info:** اطلاعات دیتابیسی که در مرحله ۱ ساختید (هاست، نام دیتابیس، یوزر و پسورد) را وارد کنید.
   - **Domain:** آدرس دامنه خود را وارد کنید.

5. صبر کنید تا اینستالر تمام کتابخانه‌ها را نصب کند و فایل‌های لازم را بسازد. اگر همه چیز درست باشد، پیام موفقیت‌آمیز سبز رنگ را خواهید دید.

---

## 5️⃣ مرحله پنجم: نهایی‌سازی و اجرا
1. به صفحه **Setup Python App** در سی‌پنل برگردید.
2. دکمه **RESTART** را برای اپلیکیشن خود بزنید.
3. حالا وب‌اپلیکیشن شما باید روی دامنه کار کند!

---

## 6️⃣ مرحله ششم: روشن نگه داشتن ربات (Cron Job)
برای اینکه ربات تلگرام شما همیشه روشن بماند و با بستن ترمینال خاموش نشود، باید یک "کرون جاب" تنظیم کنیم.

1. در سی‌پنل به بخش **ADVANCED** بروید و روی **Cron Jobs** کلیک کنید.
2. در بخش **Add New Cron Job**:
   - **Common Settings:** گزینه **Once Per Minute** (* * * * *) را انتخاب کنید.
   - **Command:** دستوری که اینستالر در مرحله آخر به شما داد را اینجا وارد کنید. دستور چیزی شبیه به این است:
     ```bash
     /bin/bash /home/username/mybot/start_bot.sh
     ```
     *(دقت کنید که آدرس‌ها دقیقاً مطابق چیزی باشد که اینستالر به شما داده است).*
3. دکمه **Add New Cron Job** را بزنید.

---

## ✅ تمام شد!
ربات و وب‌اپلیکیشن شما با موفقیت نصب و راه اندازی شدند.
- برای دسترسی به پنل مدیریت وب، آدرس دامنه خود را در مرورگر باز کنید.
- ربات تلگرام شما هم‌اکنون پاسخگو است.

**نکته:** اگر هر زمان خواستید تنظیمات را تغییر دهید، می‌توانید فایل `.env` را در File Manager ویرایش کنید و سپس اپلیکیشن پایتون را Restart کنید.
